#include <bits/stdc++.h>
using namespace std>
using ll = long long;

struct Move {
    ll x, y;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Move> moves(n);
    for(int i = 0; i < n; i++) cin >> moves[i].x >> moves[i].y;

    mt19937 rng(chrono::steady_clock::now().time_since_epoch().count());

    vector<bool> best(n,false), current(n,false);
    ll best_dist2 = 0;

    // Initialize random subset
    for(int i = 0; i < n; i++){
        if(rng() % 2) current[i] = true;
    }

    auto compute_dist2 = [&](const vector<bool> &subset){
        ll X=0,Y=0;
        for(int i=0;i<n;i++){
            if(subset[i]){
                X += moves[i].x;
                Y += moves[i].y;
            }
        }
        return X*X + Y*Y;
    };

    best_dist2 = compute_dist2(current);
    best = current;

    // Hill-climbing iterations
    int iterations = 200000; // adjust if needed
    for(int it=0; it<iterations; it++){
        int idx = rng() % n; // pick a random move to flip
        current[idx] = !current[idx];

        ll dist2 = compute_dist2(current);
        if(dist2 > best_dist2){
            best_dist2 = dist2;
            best = current; // keep new best
        } else {
            current[idx] = !current[idx]; // revert
        }
    }

    // Output
    vector<int> chosen;
    for(int i=0;i<n;i++){
        if(best[i]) chosen.push_back(i+1); // 1-based index
    }

    cout << chosen.size() << "\n";
    for(int x: chosen) cout << x << " ";
    cout << "\n";

    return 0;
}